/*
 * Decompiled with CFR 0.152.
 */
package net.pevori.queencats.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.Team;
import net.pevori.queencats.QueenCats;
import net.pevori.queencats.entity.custom.HumanoidAnimalEntity;
import net.pevori.queencats.entity.variants.HumanoidDogVariant;
import net.pevori.queencats.item.ModItems;
import net.pevori.queencats.sound.ModSounds;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class HumanoidDogEntity
extends HumanoidAnimalEntity
implements IAnimatable {
    public static final String koroSan = "korone";
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(HumanoidDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(HumanoidDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected Item itemForTaming = (Item)ModItems.GOLDEN_BONE.get();
    protected Item itemForGrowth = (Item)ModItems.KEMOMIMI_POTION.get();

    protected HumanoidDogEntity(EntityType<? extends HumanoidAnimalEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public boolean isDoog() {
        String s = this.m_7755_().getString();
        return s != null && s.toLowerCase().contains(koroSan);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving() && !this.isSitting()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoiddog.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.isSitting()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoiddog.sitting", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoiddog.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationEvent event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoiddog.attack", Boolean.valueOf(false)));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 0.0f, this::attackPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected SoundEvent m_7515_() {
        if (!QueenCats.enableDogSounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        if (this.m_5912_()) {
            return (SoundEvent)ModSounds.HUMANOID_DOG_ANGRY.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_DOG_AMBIENT.get();
    }

    public SoundEvent m_7866_(ItemStack stack) {
        if (!QueenCats.enableDogSounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_DOG_EAT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if (!QueenCats.enableDogSounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_DOG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        if (!QueenCats.enableDogSounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_DOG_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSitting(tag.m_128471_("isSitting"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isSitting", this.isSitting());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public boolean isMeat(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return item.m_41472_() && pStack.getFoodProperties((LivingEntity)this).m_38746_();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ModItems.KEMOMIMI_POTION.get();
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        this.m_21839_(sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public Team m_5647_() {
        return super.m_5647_();
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public HumanoidDogVariant getVariant() {
        return HumanoidDogVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(HumanoidDogVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }
}

